﻿-- Creating table 'HD_ActivityEvents'
CREATE TABLE [dbo].[HD_ActivityEvents] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [SiteId] int  NOT NULL,
    [Created] datetimeoffset  NOT NULL,
    [Content] nvarchar(max)  NOT NULL,
    [EventType] nvarchar(128)  NOT NULL
);
GO

-- Creating primary key on [Id] in table 'HD_ActivityEvents'
ALTER TABLE [dbo].[HD_ActivityEvents]
ADD CONSTRAINT [PK_HD_ActivityEvents]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

IF NOT EXISTS(SELECT * FROM sys.indexes WHERE name='HD_ActivityEvents_SiteId' AND object_id = OBJECT_ID('HD_ActivityEvents'))
BEGIN
	CREATE INDEX HD_ActivityEvents_SiteId
	ON dbo.HD_ActivityEvents (SiteId)
END;

